%% QR without shift
clear, clf, load Areal, chebfunsetting
A
ei = eig(A); 
[Q,H] = hess(A); 
A = H;
for ii = 1:1000
[Q,R] = qr(A);
A = R*Q;
subA(ii,:) = diag(A,-1);
end
A
semilogy(abs(subA),LW,lw)
ylim([eps 10]),shg
xlabel('Iterations')
grid on
%% plot p(lam)
xx = linspace(-4,4,1000);
plot(xx,ii*log10(abs(xx)),LW,lw),hold on
plot(ei,ii*log10(abs(ei)),'r.',MS,ms*2),shg
set(gca,FS,fs)
set(gca,'ytick',1000*[-5:5])
ylabel('log|p(\lambda)|',FS,fs)
grid on,hold off
% export_figmy(['QRsimpleoffdiagspoly'])
%% QR with shift
clear, chebfunsetting
load Areal
[Q,H] = hess(A); 
A = H; I = eye(size(A)); tol = 1e-14; ei = eig(A);
for ii = 1:100
sei = eig(A(end-1:end,end-1:end));
if abs(sei(1)-A(end,end))>abs(sei(2)-A(end,end)), 
    s = sei(2); else s = sei(1); % choose shift
end
[Q,R] = qr(A-s*eye(size(A))); % main QR step
A = R*Q+s*eye(size(A));

subA(ii,:) = [diag(A,-1).' zeros(1,length(H)-length(A))];
disp(['iteration ',num2str(ii)]), disp(A)
sit(ii) = s;
plotQRfunc(sit,H)
pause
if abs(A(end,end-1)) < tol % bottom element converged, deflate
    A = A(1:end-1,1:end-1);
    if length(A)<=1, 'QR converged', break
    end
end
end

semilogy(abs(subA(1:ii,:)),LW,lw)
ylim([eps 10]),shg
xlabel('Iterations')
grid on
%% old: plot ratfun
r = @(z)1./(prod(z-sit));
xx =linspace(-4,4,1000);  chebfunsetting
xx = [xx ei.']; xx = sort(xx);
for ii = 1:length(xx)
    rxx(ii) = r(xx(ii));
end
for ii = 1:length(ei)
    rei(ii) = r(ei(ii));
end
clf
plot(xx,log10(abs(rxx)),LW,lw),hold on
plot(ei,log10(abs(rei)),'r.',MS,ms*2),shg
set(gca,FS,fs)
set(gca,'ytick',5*[-5:5])
ylabel('log|p(\lambda)|',FS,fs)
grid on,hold off

%export_figmy(['QRshiftoffdiagsrat'])
%% generate 'good' A 
n = 5;
for ii = 1:100
A = randn(n);
if norm(imag(eig(A)))<1e-8, 
    'happy'
    break
end
end

%%
Aini = A;
%%
load Areal
%A = Aini;
%n = 5;
%A = randn(n);
[Q,H] = hess(A); 
A = H;
for ii = 1:10
[Q,R] = qr(A);
A = R*Q;
end
A
ei = eig(A);
[~,ix] = sort(abs(ei));
ei = ei(ix); 
chebfunsetting
semilogy(abs(ei.^ii),'r.',MS,ms*2),grid on, shg
title(['|r(\lambda_i)| after ',num2str(ii),' iterations'],FS,fs)
set(gca,FS,fs)
set(gca,'ytick',10.^(-10:2:10))
xlabel('eigenvalue')

