# Solution for Problem 3: Newton's method

import math


def newton_method(f, f_prime, x0, tol=1e-7, max_iter=100):
    """
    Finds a root of a function using Newton's method.
    """
    x = x0
    for i in range(max_iter):
        fx = f(x)
        if abs(fx) < tol:
            print(f"Converged after {i+1} iterations.")
            return x

        fpx = f_prime(x)
        if fpx == 0:
            print("Derivative is zero. Newton's method fails.")
            return None

        x = x - fx / fpx

    print("Exceeded maximum iterations.")
    return x


if __name__ == "__main__":
    # Define the function and its derivative
    # f(x) = sin(x) + cos(x)
    f = lambda x: math.sin(x) + math.cos(x)
    # f'(x) = cos(x) - sin(x)
    f_prime = lambda x: math.cos(x) - math.sin(x)

    print("--- Finding first root ---")
    x0_1 = 0
    root1 = newton_method(f, f_prime, x0_1)
    if root1 is not None:
        print(f"Starting from x0 = {x0_1}, found root at x = {root1:.6f}")
        print(f"Verification: f({root1:.6f}) = {f(root1):.2e}\n")

    print("--- Finding second root ---")
    x0_2 = 6
    root2 = newton_method(f, f_prime, x0_2)
    if root2 is not None:
        print(f"Starting from x0 = {x0_2}, found root at x = {root2:.6f}")
        print(f"Verification: f({root2:.6f}) = {f(root2):.2e}")
