# Solution for Problem 9: Trapezoidal rule for integration

def trap_integral(f, a, b, N):
    """
    Computes the trapezoidal rule approximation of the integral of f
    from a to b using N points (N-1 intervals).
    """
    if N < 2:
        raise ValueError("N must be at least 2 for the trapezoidal rule.")

    h = (b - a) / (N - 1)

    # Sum the first and last terms
    integral_sum = 0.5 * (f(a) + f(b))

    # Add the middle terms
    for i in range(1, N - 1):
        x = a + i * h
        integral_sum += f(x)

    return integral_sum * h
