# Solution for Problem 2: N-th Fibonacci number

def fibonacci(n):
    """
    Returns the n-th Fibonacci number.
    Assumes F_0 = 0, F_1 = 1.
    """
    if n <= 0:
        return 0
    elif n == 1:
        return 1

    a, b = 0, 1
    for _ in range(n - 1):
        a, b = b, a + b
    return b


if __name__ == "__main__":
    n = 17
    f17 = fibonacci(n)
    print(f"The {n}th Fibonacci number, F_{n}, is: {f17}")
