# Solution for Problem 4: Mirror primes

def is_prime(n):
    """
    Helper function to check if a number is prime.
    """
    if n <= 1:
        return False
    for i in range(2, int(n**0.5) + 1):
        if n % i == 0:
            return False
    return True


def find_mirror_primes(lower, upper):
    """
    Finds all mirror primes within a given range.
    """
    mirror_primes_list = []
    for m in range(lower, upper + 1):
        if is_prime(m):
            # Reverse the number
            if 10 <= m <= 99:
                reverse_m = (m % 10) * 10 + (m // 10)
                if is_prime(reverse_m):
                    mirror_primes_list.append(m)
    return mirror_primes_list


if __name__ == "__main__":
    mirror_primes = find_mirror_primes(10, 100)
    print(f"Mirror primes in the range [10, 100]: {mirror_primes}")
    print(f"There are {len(mirror_primes)} mirror primes in this range.")
