# Solution for Problem 6: Smallest positive number divisible by 1 to 10

def gcd(a, b):
    """
    Computes the greatest common divisor of a and b.
    """
    while b:
        a, b = b, a % b
    return a


def lcm(a, b):
    """
    Computes the least common multiple of a and b.
    """
    return abs(a * b) // gcd(a, b)


def smallest_multiple(n):
    """
    Finds the smallest positive number divisible by all numbers from 1 to n.
    """
    result = 1
    for i in range(1, n + 1):
        result = lcm(result, i)
    return result


if __name__ == "__main__":
    n = 10
    answer = smallest_multiple(n)
    print(f"The smallest positive number divisible by all numbers from 1 to {n} is: {answer}")
