# Solution for Problem 7: Bisection algorithm


def bisection(f, a, b, tol=1e-7, max_iter=100):
    """
    Finds a root of a function f on the interval [a, b] using the bisection method.
    """
    # Check if a root is guaranteed to be in the interval
    if f(a) * f(b) >= 0:
        print("Bisection method fails: f(a) and f(b) must have opposite signs.")
        return None

    for i in range(max_iter):
        c = (a + b) / 2
        fc = f(c)

        # Check if the midpoint is the root
        if abs(fc) < tol:
            print(f"Converged after {i+1} iterations.")
            return c

        # Decide which subinterval to use for the next iteration
        if f(a) * fc < 0:
            b = c
        else:
            a = c

    print("Exceeded maximum iterations.")
    return (a + b) / 2
