# Solution for Problem 1: Power series expansion of cos(x)

import math


def get_cosine_coefficients(n):
    """
    Computes the coefficients of the degree n power series for cos(x).
    The series is: 1 - x^2/2! + x^4/4! - ...
    """
    coeffs = []
    for i in range(n + 1):
        if i % 2 == 1:
            # Odd powers (x, x^3, etc.) have zero coefficients
            coeffs.append(0)
        else:
            # Even powers (x^0, x^2, etc.)
            # The sign alternates: +, -, +, -, ...
            sign = (-1)**(i // 2)
            coefficient = sign / math.factorial(i)
            coeffs.append(coefficient)
    return coeffs


if __name__ == "__main__":
    num_coefficients = 15
    coefficients = get_cosine_coefficients(num_coefficients - 1)

    print(f"The first {num_coefficients} coefficients of the cos(x) power series are:")
    for i, c in enumerate(coefficients):
        print(f"  a_{i}: {c:.4f}")

    total_sum = sum(coefficients)
    print(f"\nThe sum of these coefficients is: {total_sum}")
