import math
from p7 import bisection
from p8 import my_dec_to_bin
from p9 import trap_integral


def run_tests():
    """
    Runs tests for all imported functions to ensure they work.
    """
    print("--- Testing Problem 7: Bisection Method ---")
    # Test with f(x) = x^3 - x - 2 on [1, 2]
    f_bisection = lambda x: x**3 - x - 2
    root = bisection(f_bisection, 1, 2)
    if root is not None:
        print(f"Root of x^3 - x - 2 on [1, 2] found at: {root:.6f}\n")

    print("--- Testing Problem 8: Decimal to Binary ---")
    dec_num = 26
    print(f"The binary representation of {dec_num} is: {my_dec_to_bin(dec_num)}")
    print(f"Compare with built-in: {bin(dec_num)}\n")

    print("--- Testing Problem 9: Trapezoidal Integral ---")
    # Integrate sin(x) from 0 to pi. The exact answer is 2.
    f_integral = math.sin
    a, b = 0, math.pi
    N = 101  # Number of points
    integral_approx = trap_integral(f_integral, a, b, N)
    print(f"Integral of sin(x) from {a} to {b:.2f} (N={N}) is approx: {integral_approx:.6f}")
    print("Exact answer is: 2.0\n")


if __name__ == "__main__":
    print("===== RUNNING ALL TESTS =====\n")
    run_tests()
    print("===== TESTS COMPLETE =====")
