# Load necessary modules
using JuMP, Ipopt, Plots
mod = Model(Ipopt.Optimizer)

# Discretise
N=500
y=range(0,1,N)
dx=1/(N-1)

# Create N+1 decision variables , starting guess=1
@variable(mod, h[i=1:N], start=1)
@variable(mod, etaN, start=1)

# Central difference schemes for 1st and 2nd derivatives
@NLexpression(mod, hd[i=2:N-1],  (h[i+1]-h[i-1])/(2*dx))
@NLexpression(mod, hdd[i=2:N-1],  (h[i-1]-2*h[i]+h[i+1])/dx^2)

# Forward difference scheme for the first point
@NLexpression(mod, hd1,  (-3/2*h[1]+2*h[2]-1/2*h[3])/dx)

# Create ODE expressions
@NLexpression(mod, ODE[i=2:N-1],  1/3*etaN^2*(h[i]-2*y[i]*hd[i])-(h[i]*hdd[i]+hd[i]^2))

# Create integral expression (trapezoidal rule)
@NLexpression(mod, integral,  1/2*etaN*dx*(h[1]+h[N]+sum(2*h[i] for i=2:N-1)))

# Create objective function = square of all the equations we want to satisfy
@NLexpression(mod, my_obj, (h[1]*hd1+etaN)^2+h[N]^2+(integral-1)^2+sum(ODE[i]^2 for i=2:N-1))

# Set the objective and run the optimizer
@NLobjective(mod, Min, my_obj )
optimize!(mod)

# Plot the solution
plot(y,value.(h))

println(value(etaN))
