%% Project C: Hailstone numbers
% Candidate number 2124124
clear, close all

%% Exercise C1
type sequence.m

%%
% Test the function sequence.m with a couple of starting values a.
seq1 = sequence(4)
seq2 = sequence(11)

%% Exercise C2
% Experiment with different values of a.
avals = [14, 39, 40, 62, 92];
for a = avals
    seq = sequence(a);
    figure
    plot(seq,'*-')
    title(['Sequence with starting value a = ',num2str(a)])
end

%%
% These are called hailstone numbers because the sequence of numbers rises
% and falls a bit like bouncing hailstones, but eventually, for these
% values of a, falls to 1 (and then the sequence would just repeat 4, 2,
% 1).


%% Exercise C3
% Find the maximum value in the sequence for each a from 1 to 50.
maxx = zeros(1,50);
for a = 1:50
    seq = sequence(a);
    maxx(a) = max(seq);
end
figure
semilogy(1:50,maxx,'b',1:50,1:50,'r')
legend('max value of sequence','a','location','southeast')
xlabel('starting value a')
ylabel('max value in sequence')
title('Maximum value reached by the Collatz sequence')

%%
% The maximum value in the sequence roughly increases with a.
% This is expected because the maximum must be at least a.
% Clearly if a is a power of 2, then a must be the maximum value in the
% sequence (except if a=2 when the maximum is 4).
% We can also see that if a=20, 24, 40 or 48 then a is also the maximum.
% In general though, the maximum is higher than a so the sequence must have
% increased at some point. In particular, if a is odd, then x1=3*a+1>a.

%% Exercise C4
% Find the repeating part of the sequence.
avals = [14, 39, 40, 62, 92];
for a = avals
   seq = sequence(a);
   N = find(seq(1:end-1) == seq(end));
   disp(['a = ',num2str(a),': end of sequence is [',num2str(seq(N:end)),']'])
end

%%
% The last part of the sequence, prior to repeats is always 4,2,1.
% The exception is when a=2 and we get 2,1,4.

%% Exercise C5
type sequence2.m

%%
% Now check whether the sequences starting at a for a=2:10000 reach the
% value 1. If they do, the function sequence2.m will terminate for each a.
for a = 2:10000
    seq = sequence2(a);
end
disp('All cases checked')

%%
% Since the function sequence2.m completes for each value of a, the
% sequence gets to the value x(n)=1 for some n.
