function seq = sequence(a)
% Compute the sequence with entries, x_0 = a and for n>=1
% x_{n} = x_{n-1}/2     if x_{n-1} is even
%         3*x_{n-1}+1   if x_{n-1} is odd
% Stop when we have an entry that already appears in the sequence

x = a;
n = 1;
while 0 == 0
    if x(n)/2 == floor(x(n)/2) 
        % then x(n) is even
        nextx = x(n)/2;
    else
        % x(n) is odd
        nextx = 3*x(n)+1;
    end
    if ismember(nextx,x)
        % this number already appears in the sequence
        x = [x, nextx];
        break
    else
        x = [x,nextx];
        n = n+1;
    end
end
seq = x;
