function seq = sequence2(a)
% Compute the sequence with entries, x_0 = a and for n>=1
% x_{n} = x_{n-1}/2     if x_{n-1} is even
%         3*x_{n-1}+1   if x_{n-1} is odd
% Stop when we have an entry that is 1

x = a;
n = 1;
while 0 == 0
    if x(n)/2 == floor(x(n)/2) 
        % then x(n) is even
        nextx = x(n)/2;
    else
        % x(n) is odd
        nextx = 3*x(n)+1;
    end
    if nextx == 1
        % the sequence has got to 1
        x = [x, nextx];
        break
    else
        x = [x,nextx];
        n = n+1;
    end
end
seq = x;
